---------------
-- Stamina Gym
---------------

local Archi = setmetatable({},NPC):new( 9, 3, "Archi 4x4.png", "Down" )

Archi.Action = function()

	if SRT.Defeated.Archi then
		SRT.Dialog.Words = {{text=THEME:GetString("StaminaGym", "7")}}
	else
		SRT.Dialog.Words = {
			{ text=THEME:GetString("StaminaGym", "1") },
			{ text=THEME:GetString("StaminaGym", "2") },
			{ text=THEME:GetString("StaminaGym", "3") },
			{ text=THEME:GetString("StaminaGym", "4") },
			{ text=THEME:GetString("StaminaGym", "5") },
			{ text=THEME:GetString("StaminaGym", "6") },
			{
				text=function()
					TransitionToBattle(3)
					return ""
				end
			}
		}
	end

	StartDialog("#73ca6d", "Archi")
end

return {

	--exit map via bottom
	{
		Tile = { r=9, d=11 },
		Trigger = "PlayerTouch",
		Action = function()
			SRT.Transition.NextMap="Hometown"
			SRT.Transition.NextPos={ r=15, d=4, z=-1 }
			SRT.MapFade:queuecommand("FadeOut")
		end

	},

	-- EndGame
	{
		Tile = { r=9, d=9 },
		Trigger = "PlayerTouch",
		Action = function()
			if IsEndGame() then
				SRT.Dialog.Words = {{text="HEEEEEEEELP!!!\n" .. SRT.Player.Name .. ", come to the Pokémon Center quickly!"}}
				StartDialog("#666666", "Sami")
			end
		end
	},

	Archi,

	-- green torches
	setmetatable({}, AnimatedSprite):new(8, 11, "greentorch", 0.1),
	setmetatable({}, AnimatedSprite):new(8, 10, "greentorch", 0.15),
	setmetatable({}, AnimatedSprite):new(8, 9, "greentorch", 0.2),
	setmetatable({}, AnimatedSprite):new(8, 8, "greentorch", 0.1),
	setmetatable({}, AnimatedSprite):new(8, 7, "greentorch", 0.125),
	setmetatable({}, AnimatedSprite):new(8, 6, "greentorch", 0.12),
	setmetatable({}, AnimatedSprite):new(7, 5, "greentorch", 0.1),
	setmetatable({}, AnimatedSprite):new(7, 4, "greentorch", 0.133),
	setmetatable({}, AnimatedSprite):new(7, 3, "greentorch", 0.2),
	setmetatable({}, AnimatedSprite):new(10, 11, "greentorch", 0.15),
	setmetatable({}, AnimatedSprite):new(10, 10, "greentorch", 0.125),
	setmetatable({}, AnimatedSprite):new(10, 9, "greentorch", 0.133),
	setmetatable({}, AnimatedSprite):new(10, 8, "greentorch", 0.135),
	setmetatable({}, AnimatedSprite):new(10, 7, "greentorch", 0.2),
	setmetatable({}, AnimatedSprite):new(10, 6, "greentorch", 0.125),
	setmetatable({}, AnimatedSprite):new(11, 5, "greentorch", 0.1),
	setmetatable({}, AnimatedSprite):new(11, 4, "greentorch", 0.135),
	setmetatable({}, AnimatedSprite):new(11, 3, "greentorch", 0.15),
}